<?php
session_start();
require_once "db.php";

// Hakikisha user amelogin
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch user's withdrawals
$stmt = $conn->prepare("SELECT amount, fee, net_amount, status, created_at FROM withdrawals WHERE user_id = ? ORDER BY created_at DESC");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$withdrawals = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Withdrawal Records</title>
<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
body { margin:0; font-family: Arial, sans-serif; background: url("car.jpg") no-repeat center center fixed; background-size: cover; color:#fff; }
.overlay { background: rgba(0,0,0,0.6); min-height:100vh; padding-top: 60px; padding-bottom: 60px; }
.header { position: fixed; top:0; left:0; right:0; background: rgba(0,0,0,0.7); text-align:center; font-size:20px; font-weight:bold; padding:14px; z-index:1000; }
.content { max-width: 500px; margin: 0 auto; padding: 0 14px; }
.withdrawal-card { background: #1a1c1b; padding:12px 16px; border-radius:10px; margin-bottom:12px; box-shadow: 0 4px 8px rgba(0,0,0,0.2); }
.withdrawal-card .row { display:flex; justify-content: space-between; margin-bottom:6px; }
.withdrawal-card .row span { font-size:14px; }
.withdrawal-card .status { font-weight:bold; color:#2CFF70; }
.withdrawal-card .status.pending { color: #ffbb33; }
.withdrawal-card .status.rejected { color:#ff5555; }

</style>
</head>
<body>
<div class="overlay">
    <div class="header">My Withdrawals</div>
    <div class="content">
        <?php if(count($withdrawals) === 0): ?>
            <p style="text-align:center; color:#fff; margin-top:20px;">No withdrawal records found.</p>
        <?php else: ?>
            <?php foreach($withdrawals as $w): ?>
                <div class="withdrawal-card">
                    <div class="row"><span>Amount:</span> <span><?php echo number_format($w['amount'],0); ?> TZS</span></div>
                    <div class="row"><span>Fee:</span> <span><?php echo number_format($w['fee'],0); ?> TZS</span></div>
                    <div class="row"><span>Net:</span> <span><?php echo number_format($w['net_amount'],0); ?> TZS</span></div>
                    <div class="row"><span>Status:</span> 
                        <span class="status <?php echo strtolower($w['status']); ?>"><?php echo ucfirst($w['status']); ?></span>
                    </div>
                    <div class="row"><span>Date:</span> <span><?php echo date("d M Y H:i", strtotime($w['created_at'])); ?></span></div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
   
</div>
</body>
</html>
