<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>CarCash Register</title>
  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      background: url("car.jpg") no-repeat center center fixed;
      background-size: cover;
      color: #fff;
    }
    .overlay {
      background-color: rgba(13, 15, 14, 0.9);
      width: 100%;
      min-height: 100vh;
    }
    .container {
      max-width: 400px;
      margin: 0 auto;
      padding: 30px 20px;
      text-align: center;
    }
    .logo {
      margin-top: 40px;
    }
    .logo img {
      width: 120px;
      height: 120px;
      border-radius: 50%;
      object-fit: cover;
    }
    .input-group {
      display: flex;
      align-items: center;
      background-color: #1A1C1B;
      border-radius: 10px;
      padding: 0 12px;
      margin-top: 25px;
      height: 55px;
      position: relative;
    }
    .input-group span {
      color: #9FA6AD;
      font-size: 16px;
      margin-right: 10px;
    }
    .input-group input {
      flex: 1;
      background: transparent;
      border: none;
      outline: none;
      font-size: 16px;
      color: #fff;
    }
    .input-group input::placeholder {
      color: #9FA6AD;
    }
    .toggle-password {
      position: absolute;
      right: 12px;
      cursor: pointer;
      width: 22px;
      height: 22px;
      fill: #9FA6AD;
    }
    .btn-register {
      width: 100%;
      background: #2CFF70;
      border: none;
      border-radius: 10px;
      height: 55px;
      font-size: 18px;
      font-weight: bold;
      margin-top: 25px;
      cursor: pointer;
      color: #000;
    }
    .links {
      margin-top: 15px;
      font-size: 14px;
    }
    .links a {
      color: #fff;
      text-decoration: none;
      margin: 0 4px;
    }
    .links a.login {
      color: #2CFF70;
    }
  </style>
</head>
<body>
  <div class="overlay">
    <div class="container">

      <!-- Logo -->
      <div class="logo">
        <img src="byds.jpg" alt="CarCash Logo">
      </div>

      <!-- Phone Number -->
      <div class="input-group">
        <span>+255</span>
        <input type="tel" placeholder="Phone Number">
      </div>

      <!-- Invitation Code -->
      <div class="input-group">
        <input type="text" placeholder="Invitation Code">
      </div>

      <!-- Password -->
      <div class="input-group">
        <input type="password" id="password" placeholder="Password">
        <svg id="togglePassword" class="toggle-password" viewBox="0 0 24 24">
          <path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 
                   4.39 6 7.5 11 7.5s9.27-3.11 
                   11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 
                   17c-2.76 0-5-2.24-5-5s2.24-5 
                   5-5 5 2.24 5 5-2.24 5-5 
                   5zm0-8c-1.66 0-3 1.34-3 
                   3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"/>
        </svg>
      </div>

      <!-- Confirm Password -->
      <div class="input-group">
        <input type="password" id="confirm" placeholder="Confirm Password">
        <svg id="toggleConfirm" class="toggle-password" viewBox="0 0 24 24">
          <path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 
                   4.39 6 7.5 11 7.5s9.27-3.11 
                   11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 
                   17c-2.76 0-5-2.24-5-5s2.24-5 
                   5-5 5 2.24 5 5-2.24 5-5 
                   5zm0-8c-1.66 0-3 1.34-3 
                   3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"/>
        </svg>
      </div>

      <!-- Register Button -->
      <button class="btn-register">Register</button>

      <!-- Link to Login -->
      <div class="links">
        Already have an account? <a href="login.php" class="login">Login</a>
      </div>

    </div>
  </div>

  <script>
    function setupToggle(inputId, toggleId) {
      const input = document.getElementById(inputId);
      const toggle = document.getElementById(toggleId);
      toggle.addEventListener("click", () => {
        if (input.type === "password") {
          input.type = "text";
          toggle.style.fill = "#2CFF70"; // active color
        } else {
          input.type = "password";
          toggle.style.fill = "#9FA6AD"; // default color
        }
      });
    }
    setupToggle("password", "togglePassword");
    setupToggle("confirm", "toggleConfirm");
  </script>
</body>
</html>
