<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Redeem Gift Code</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      background: url("car.jpg") no-repeat center center fixed;
      background-size: cover;
      color: #fff;
    }
    .overlay {
      background: rgba(0,0,0,0.65);
      min-height: 100vh;
      display: flex;
      flex-direction: column;
      align-items: center;
      padding: 20px;
    }

    /* Header */
    .header {
      width: 100%;
      text-align: center;
      padding: 14px;
      font-size: 20px;
      font-weight: bold;
      background: rgba(0,0,0,0.7);
      border-radius: 8px;
      margin-bottom: 40px;
    }

    /* Gift box */
    .gift-box {
      background: #fff;
      color: #333;
      border-radius: 14px;
      box-shadow: 0 6px 18px rgba(0,0,0,0.4);
      padding: 20px;
      width: 90%;
      max-width: 400px;
      text-align: center;
    }
    .gift-box i {
      font-size: 40px;
      color: #e65100;
      margin-bottom: 15px;
    }
    .gift-box h2 {
      margin: 0 0 10px 0;
      font-size: 20px;
      color: #222;
    }
    .gift-box p {
      font-size: 14px;
      color: #555;
      margin-bottom: 20px;
    }

    /* Input */
    .gift-box input {
      width: 93%;
      padding: 12px;
      font-size: 15px;
      border-radius: 8px;
      border: 1px solid #ccc;
      margin-bottom: 15px;
      outline: none;
    }

    /* Button */
    .gift-box button {
      width: 100%;
      padding: 12px;
      font-size: 16px;
      border: none;
      border-radius: 8px;
      background: #2e7d32;
      color: #fff;
      font-weight: bold;
      cursor: pointer;
      transition: 0.3s;
    }
    .gift-box button:hover {
      background: #1b5e20;
    }

    /* Feedback */
    .message {
      margin-top: 15px;
      font-size: 14px;
      font-weight: bold;
    }
    .success { color: green; }
    .error { color: red; }
  </style>
</head>
<body>
  <div class="overlay">

    <!-- Header -->
    <div class="header">Redeem Gift Code</div>

    <!-- Gift Form -->
    <div class="gift-box">
      <i class="fas fa-gift"></i>
      <h2>Enter Your Gift Code</h2>
      <p>Redeem your code to unlock rewards instantly.</p>

      <form id="giftForm">
        <input type="text" id="giftCode" placeholder="Enter gift code..." required>
        <button type="submit">Redeem</button>
      </form>

      <div id="message" class="message"></div>
    </div>

  </div>

  <script>
    const form = document.getElementById("giftForm");
    const messageBox = document.getElementById("message");

    form.addEventListener("submit", function(e) {
      e.preventDefault();
      const code = document.getElementById("giftCode").value.trim();

      if (code === "") {
        messageBox.textContent = "⚠ Please enter a gift code!";
        messageBox.className = "message error";
        return;
      }

      // Example only: hapa ndio utaunganisha na backend yako (PHP)
      if (code === "BYD123") {
        messageBox.textContent = "✅ Gift code redeemed successfully! KES 500 added.";
        messageBox.className = "message success";
      } else {
        messageBox.textContent = "❌ Invalid gift code. Try again.";
        messageBox.className = "message error";
      }
    });
  </script>
</body>
</html>
