<?php
// withdraw.php
session_start();
require_once "db.php"; 

date_default_timezone_set('Africa/Nairobi'); // Set Kenya time

// hakikisha user amelogin
if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$message = "";

// Fetch balance ya user
$stmt = $conn->prepare("SELECT balance FROM users WHERE id=?");
$stmt->bind_param("i",$user_id);
$stmt->execute();
$stmt->bind_result($balance);
$stmt->fetch();
$stmt->close();

// Fetch fund password kutoka user_bank_details
$stmt = $conn->prepare("SELECT fund_password FROM user_bank_details WHERE user_id=? LIMIT 1");
$stmt->bind_param("i",$user_id);
$stmt->execute();
$stmt->bind_result($fund_password_db);
$stmt->fetch();
$stmt->close();

$current_hour = intval(date("H")); // current hour 0-23

if($_SERVER["REQUEST_METHOD"]=="POST"){
    $amount = floatval($_POST['amount']);
    $password = trim($_POST['password']);

    // Check time restriction
    if($current_hour < 9 || $current_hour >= 17){
        $message = "⚠ Withdrawals are allowed only between 9 AM and 5 PM";
    } elseif($amount < 2500){
        $message = "⚠ Minimum withdrawal is TZS 2,500";
    } elseif(!$fund_password_db){
        $message = "⚠ Please set your bank details first in bank Card";
    } elseif($password !== $fund_password_db){
        $message = "⚠ Invalid fund password";
    } elseif($amount > $balance){
        $message = "⚠ Insufficient balance";
    } else {
        // calculate fee
        $fee = round($amount * 0.13,2);
        $net_amount = $amount - $fee;

        // insert withdrawal record
        $stmt = $conn->prepare("INSERT INTO withdrawals(user_id,amount,fee,net_amount,status,created_at) VALUES(?,?,?,?,?,NOW())");
        $status = "pending";
        $stmt->bind_param("iddds",$user_id,$amount,$fee,$net_amount,$status);
        if($stmt->execute()){
            // update balance
            $stmt2 = $conn->prepare("UPDATE users SET balance = balance - ? WHERE id=?");
            $stmt2->bind_param("di",$amount,$user_id);
            $stmt2->execute();
            $stmt2->close();

            $message = "✅ Withdrawal request submitted successfully!";
        } else {
            $message = "⚠ Failed to submit withdrawal!";
        }
        $stmt->close();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Withdraw</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    body {margin:0;font-family: Arial, sans-serif;background: url('car.jpg') no-repeat center center fixed;background-size: cover;}
    .overlay {background: rgba(0,0,0,0.55);min-height:100vh;display:flex;flex-direction:column;padding-bottom:20px;}
    .header {color:#fff;text-align:center;padding:14px;font-size:21px;font-weight:bold;position:fixed;top:0;left:0;right:0;background: rgba(0,0,0,0.6);z-index:1000;}
    .content {padding:14px;margin-top:70px;}
    .balance-card {background:#fff;border-radius:12px;padding:20px;text-align:center;margin-bottom:20px;box-shadow:0 4px 10px rgba(0,0,0,0.25);}
    .balance-card h3 {margin:0;font-size:15px;color:#666;}
    .balance-card .amount {font-size:28px;font-weight:bold;margin-top:8px;color:#2e7d32;}
    .form-card {background:#fff;border-radius:12px;padding:20px;box-shadow:0 4px 10px rgba(0,0,0,0.25);margin-bottom:15px;}
    .form-card label {display:block;margin-bottom:6px;font-size:14px;color:#333;}
    .form-card input {width:93%;padding:10px;border-radius:8px;border:1px solid #ccc;margin-bottom:15px;font-size:14px;}
    .form-card button {width:100%;padding:14px;border:none;border-radius:12px;background:#2e7d32;color:#fff;font-size:16px;font-weight:bold;cursor:pointer;}
    .form-card button:hover {background:#256428;}
    .message {background:#fff;color:#2e7d32;padding:10px;border-radius:8px;margin:10px 0;text-align:center;font-weight:bold;}
    .quick-amounts {display:flex;flex-wrap:wrap;gap:10px;margin-bottom:15px;}
    .quick-amounts button {flex:1;padding:10px 0;border:none;border-radius:8px;background:#f0f0f0;font-weight:bold;cursor:pointer;}
    .quick-amounts button:hover {background:#ddd;}
    .notes {background:rgba(255,255,255,0.9);border-radius:12px;padding:14px;font-size:13px;color:#444;line-height:1.5;box-shadow:0 4px 8px rgba(0,0,0,0.2);}
    .notes h4 {margin-top:0;margin-bottom:8px;font-size:14px;font-weight:bold;color:#2e7d32;}
    .notes ul {padding-left:20px;margin:0;}
  </style>
</head>
<body>
  <div class="overlay">
    <div class="header">Withdraw</div>
    <div class="content">

      <div class="balance-card">
        <h3>Your Balance</h3>
        <div class="amount">TZS <?php echo number_format($balance,2); ?></div>
      </div>

      <div class="form-card">
        <?php if($message): ?>
          <div class="message"><?php echo $message; ?></div>
        <?php endif; ?>
        <form method="post">
          <label for="amount">Amount to Withdraw (TZS)</label>
          <div class="quick-amounts">
            <button type="button" onclick="setAmount(2500)">2,500</button>
            <button type="button" onclick="setAmount(8000)">8,000</button>
            <button type="button" onclick="setAmount(30000)">30,000</button>
            <button type="button" onclick="setAmount(50000)">50,000</button>
          </div>
          <input type="number" id="amount" name="amount" placeholder="Enter amount" min="2500" required>
          
          <label for="password">Fund Password</label>
          <input type="password" id="password" name="password" placeholder="Enter fund password" required>
          
          <button type="submit">Withdraw Now</button>
        </form>
      </div>

      <div class="notes">
        <h4>Notes / Guidelines</h4>
        <ul>
          <li>Minimum withdrawal amount is TZS 2,500.</li>
          <li>Withdrawals have a 13% fee deducted.</li>
          <li>Withdrawals allowed only between 9 AM and 5 PM.</li>
          <li>You must have bank details set in bank.php first.</li>
          <li>Use correct fund password for security verification.</li>
        </ul>
      </div>

    </div>
  </div>
<script>
function setAmount(val){
  document.getElementById('amount').value = val;
}
</script>
</body>
</html>
