<?php
session_start();
require_once "db.php"; // connection yako ya DB

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $phone = trim($_POST['phone'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if (empty($phone) || empty($password)) {
        $error = "Please enter both phone and password.";
    } else {
        // Check if user exists
        $stmt = $conn->prepare("SELECT id, password FROM users WHERE phone = ?");
        $stmt->bind_param("s", $phone);
        $stmt->execute();
        $stmt->bind_result($user_id, $hashed_password);
        if ($stmt->fetch()) {
            if (password_verify($password, $hashed_password)) {
                // Password correct, set session
                $_SESSION['user_id'] = $user_id;
                header("Location: home.php");
                exit;
            } else {
                $error = "Incorrect password.";
            }
        } else {
            $error = "Phone number not found.";
        }
        $stmt->close();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>CarCash Login</title>
  <style>
    body { margin:0; font-family: Arial, sans-serif; background: url("car.jpg") no-repeat center center fixed; background-size: cover; color:#fff; }
    .overlay { background-color: rgba(13,15,14,0.9); width:100%; min-height:100vh; }
    .container { max-width:400px; margin:0 auto; padding:30px 20px; text-align:center; }
    .logo { margin-top:40px; }
    .logo img { width:120px; height:120px; border-radius:50%; object-fit:cover; }
    .input-group { display:flex; align-items:center; background-color:#1A1C1B; border-radius:10px; padding:0 12px; margin-top:30px; height:55px; position:relative; }
    .input-group span { color:#9FA6AD; font-size:16px; margin-right:10px; }
    .input-group input { flex:1; background:transparent; border:none; outline:none; font-size:16px; color:#fff; }
    .input-group input::placeholder { color:#9FA6AD; }
    .toggle-password { position:absolute; right:12px; cursor:pointer; width:22px; height:22px; fill:#9FA6AD; }
    .links { margin-top:12px; font-size:14px; }
    .links a { color:#fff; text-decoration:none; margin:0 4px; }
    .links a.register { color:#2CFF70; }
    .btn-login { width:100%; background:#2CFF70; border:none; border-radius:10px; height:55px; font-size:18px; font-weight:bold; margin-top:25px; cursor:pointer; color:#000; }
    .btn-customer { width:100%; background:#000; border:none; border-radius:10px; height:55px; font-size:18px; font-weight:bold; margin-top:15px; cursor:pointer; color:#fff; display:flex; align-items:center; justify-content:center; gap:8px; }
    .error { color:#ff5555; margin-top:10px; }
  </style>
</head>
<body>
  <div class="overlay">
    <div class="container">

      <div class="logo">
        <img src="byds.jpg" alt="CarCash Logo">
      </div>

      <?php if(!empty($error)) echo '<div class="error">'.$error.'</div>'; ?>

      <form method="POST">

        <div class="input-group">
          <span>+255</span>
          <input type="tel" name="phone" placeholder="Phone Number" required>
        </div>

        <div class="input-group">
          <input type="password" id="password" name="password" placeholder="Password" required>
          <svg id="togglePassword" class="toggle-password" viewBox="0 0 24 24">
            <path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 
                     4.39 6 7.5 11 7.5s9.27-3.11 
                     11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 
                     17c-2.76 0-5-2.24-5-5s2.24-5 
                     5-5 5 2.24 5 5-2.24 5-5 
                     5zm0-8c-1.66 0-3 1.34-3 
                     3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"/>
          </svg>
        </div>

        <div class="links">
          <a href="#">Forgot Password</a> | <a href="register.php" class="register">Register</a>
        </div>

        <button type="submit" class="btn-login">Login</button>

      </form>

      <button class="btn-customer">
        Customer Service
      </button>

    </div>
  </div>

  <script>
    const password = document.getElementById("password");
    const toggle = document.getElementById("togglePassword");
    toggle.addEventListener("click", () => {
      if (password.type === "password") {
        password.type = "text";
        toggle.style.fill = "#2CFF70"; 
      } else {
        password.type = "password";
        toggle.style.fill = "#9FA6AD"; 
      }
    });
  </script>
</body>
</html>
